package editor;

import game.IntRect;
import game.PlayingWithCosine;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedWriter;

public class HurtzoneScreenObject extends MobileScreenObject {
	
	private boolean isSelected = false;
	
	private IntRect clickRect;
	
	private HurtzonePaletteObject paletteObject;
	
	
	
	
	public HurtzoneScreenObject(HurtzonePaletteObject thePaletteObject, IntRect theClickRect) {
		
		clickRect = theClickRect;
		isSelected = false;
		
		paletteObject = thePaletteObject;
		
		this.setVertical(paletteObject.isVertical());
		
		Point center = clickRect.getCenter();
		
		if(paletteObject.isVertical()) {
			this.setMin(center.y);
			this.setMax(center.y);
		} else {
			this.setMin(center.x);
			this.setMax(center.x);
		}
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		
		

		Point center = clickRect.getCenter();
		
		
		Color origCol = g.getColor();
		
		if(isVertical()) {
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMin());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMin());
			
			g.setColor(new Color(0, 51, 255));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMin());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMin());
			
			g.setColor(new Color(0, 102, 255));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMin());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMin());
			
			g.setColor(new Color(0, 153, 255));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMin());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMin());
			
			g.setColor(new Color(0, 204, 255));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMin());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMin());
			
			g.setColor(new Color(0, 255, 255));
			g.drawLine(center.x, center.y, center.x, this.getMin());
			g.drawLine(center.x + 10, this.getMin(), center.x - 10, this.getMin());
			
			
			
			
			g.setColor(new Color(255, 0, 0));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMax());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMax());
			
			g.setColor(new Color(255, 51, 0));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMax());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMax());
			
			g.setColor(new Color(255, 102, 0));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMax());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMax());
			
			g.setColor(new Color(255, 153, 0));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMax());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMax());
			
			g.setColor(new Color(255, 204, 0));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMax());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMax());
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, center.x, this.getMax());
			g.drawLine(center.x + 10, this.getMax(), center.x - 10, this.getMax());
		} else {
			g.setColor(new Color(0, 255, 0));
			g.drawLine(center.x, center.y - 5, this.getMin(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMin(), center.y + 5);
			
			g.setColor(new Color(51, 255, 0));
			g.drawLine(center.x, center.y - 4, this.getMin(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMin(), center.y + 4);
			
			g.setColor(new Color(102, 255, 0));
			g.drawLine(center.x, center.y - 3, this.getMin(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMin(), center.y + 3);
			
			g.setColor(new Color(153, 255, 0));
			g.drawLine(center.x, center.y - 2, this.getMin(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMin(), center.y + 2);
			
			g.setColor(new Color(204, 255, 0));
			g.drawLine(center.x, center.y - 1, this.getMin(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMin(), center.y + 1);
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, this.getMin(), center.y);
			g.drawLine(this.getMin(), center.y - 10, this.getMin(), center.y + 10);
			
			
			
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x, center.y - 5, this.getMax(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMax(), center.y + 5);
			
			g.setColor(new Color(51, 0, 255));
			g.drawLine(center.x, center.y - 4, this.getMax(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMax(), center.y + 4);
			
			g.setColor(new Color(102, 0, 255));
			g.drawLine(center.x, center.y - 3, this.getMax(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMax(), center.y + 3);
			
			g.setColor(new Color(153, 0, 255));
			g.drawLine(center.x, center.y - 2, this.getMax(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMax(), center.y + 2);
			
			g.setColor(new Color(204, 0, 255));
			g.drawLine(center.x, center.y - 1, this.getMax(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMax(), center.y + 1);
			
			g.setColor(new Color(255, 0, 255));
			g.drawLine(center.x, center.y, this.getMax(), center.y);
			g.drawLine(this.getMax(), center.y - 10, this.getMax(), center.y + 10);
		}
		

		g.setColor(new Color(0, 150, 0));
		g.drawString("cd:" + HurtzonePaletteObject.multiplyIntByAThousandAndReturnAsString(paletteObject.getMinimumWaitTime()), clickRect.getMinX() + 3, clickRect.getMinY() + 40);
		g.setColor(new Color(200, 0, 0));
		g.drawString("d:" + paletteObject.getDamage(), clickRect.getMinX() + 36, clickRect.getMinY() + 20);
		g.setColor(new Color(50, 100, 150));
		g.drawString("du:"+ HurtzonePaletteObject.multiplyIntByAThousandAndReturnAsString(paletteObject.getDuration()), clickRect.getMinX() + 3, clickRect.getMinY() + 50);
		
		double minColor = paletteObject.getMinColor();
		double maxColor = paletteObject.getMaxColor();
		
		double avgColor = (minColor + maxColor) / 2;
		
		Color maybeIShouldntHaveCalledTheLastOneAvgColor = PlayingWithCosine.scalarToColor(avgColor);
		
		g.setColor(maybeIShouldntHaveCalledTheLastOneAvgColor);
		
		
		g.drawRect(clickRect.getMinX(), clickRect.getMinY(), clickRect.width(), clickRect.height());
		g.drawRect(clickRect.getMinX()+1, clickRect.getMinY()+1, clickRect.width()-2, clickRect.height()-2);
		
		
		
		
		g.setColor(origCol);
		
		

		paletteObject.getImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		if(this.isSelected)
			drawSelectionOverObject(g);
		
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		// TODO Auto-generated method stub
		return isSelected;
	}
	
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception {
		
		Point center = this.getClickRect().getCenter();
		
		out.write("hurtzone:");
		out.newLine();
		
		out.write("x:");
		out.write(Integer.toString(center.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(center.y));
		out.newLine();
		
		if(this.isVertical()) {
			out.write("vertical");
		} else {
			out.write("horizontal");
		}
		out.newLine();
		
		out.write("min:");
		out.write(Integer.toString(this.getMin()));
		out.newLine();
		
		out.write("max:");
		out.write(Integer.toString(this.getMax()));
		out.newLine();
		
		out.write("duration:");
		out.write(Integer.toString(this.paletteObject.getDuration()));
		out.newLine();
		
		out.write("minTimeBetween:");
		out.write(Integer.toString(this.paletteObject.getMinimumWaitTime()));
		out.newLine();
		
		out.write("chancePerTickNumerator:");
		out.write(Integer.toString(this.paletteObject.getFireChanceNumerator()));
		out.newLine();
		
		out.write("chancePerTickDenominator:");
		out.write(Integer.toString(this.paletteObject.getFireChanceDenominator()));
		out.newLine();
		
		out.write("warmupTime:");
		out.write(Integer.toString(this.paletteObject.getWarmupTime()));
		out.newLine();
		
		out.write("damage:");
		out.write(Integer.toString(this.paletteObject.getDamage()));
		out.newLine();
		
		out.write("minColor:");
		out.write(Double.toString(this.paletteObject.getMinColor()));
		out.newLine();
		
		out.write("maxColor:");
		out.write(Double.toString(this.paletteObject.getMaxColor()));
		out.newLine();
		
		out.write("/hurtzone");
		out.newLine();
		
		out.newLine();
		
	}
	
	@Override
	public int getLayer() {
		
		return 16;
	}
	
}
